
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { ArrowLeft } from 'lucide-react';

export default function PrivacyPolicyPage() {
  return (
    <div className="max-w-4xl mx-auto p-4 md:p-6 bg-background text-foreground min-h-screen">
      <div className="flex items-center gap-4 mb-6">
        <Link href="/">
          <Button variant="outline" size="icon">
            <ArrowLeft className="h-4 w-4" />
          </Button>
        </Link>
        <h1 className="text-3xl font-bold">Política de Privacidade</h1>
      </div>

      <Card>
        <CardHeader>
          <CardTitle>Política de Privacidade</CardTitle>
          <CardDescription>Última atualização: Outubro de 2023</CardDescription>
        </CardHeader>
        <CardContent className="space-y-4">
          <p>
            A sua privacidade é importante para nós. É política do nosso restaurante respeitar a sua privacidade em relação a qualquer informação sua que possamos coletar no nosso cardápio digital.
          </p>

          <h3 className="font-semibold text-lg">1. Coleta de Dados</h3>
          <p>
            Solicitamos informações pessoais apenas quando realmente precisamos delas para lhe fornecer um serviço. Fazemo-lo por meios justos e legais, com o seu conhecimento e consentimento. As informações que coletamos incluem seu nome, endereço de entrega e detalhes do pedido, que são utilizados exclusivamente para processar e entregar seu pedido.
          </p>

          <h3 className="font-semibold text-lg">2. Uso dos Dados</h3>
          <p>
            Os dados coletados (nome, endereço e pedido) são compartilhados via WhatsApp para a logística de preparo e entrega. Não compartilhamos suas informações de identificação pessoal publicamente ou com terceiros, exceto quando exigido por lei.
          </p>

           <h3 className="font-semibold text-lg">3. Armazenamento de Dados</h3>
          <p>
            Retemos as informações coletadas pelo tempo necessário para fornecer o serviço solicitado. Quando armazenamos dados, protegemos dentro de meios comercialmente aceitáveis para evitar perdas e roubos, bem como acesso, divulgação, cópia, uso ou modificação não autorizados.
          </p>
          
           <h3 className="font-semibold text-lg">4. Rastreamento e Cookies</h3>
          <p>
            Podemos usar scripts de rastreamento (como Google Analytics e Facebook Pixel) para fins de marketing e para entender melhor nossos usuários. Esses serviços podem coletar dados de forma anônima sobre sua navegação. Você pode gerenciar suas preferências de cookies através do seu navegador.
          </p>

          <h3 className="font-semibold text-lg">5. Compromisso do Usuário</h3>
          <p>
           O usuário se compromete a fazer uso adequado dos conteúdos e da informação que o nosso cardápio digital oferece e com caráter enunciativo, mas não limitativo: a) não se envolver em atividades que sejam ilegais ou contrárias à boa fé e à ordem pública; b) não difundir propaganda ou conteúdo de natureza racista, xenofóbica, ou sobre azar, qualquer tipo de pornografia ilegal, de apologia ao terrorismo ou contra os direitos humanos.
          </p>

           <h3 className="font-semibold text-lg">6. Contato</h3>
          <p>
            Se você tiver alguma dúvida sobre como lidamos com dados do usuário e informações pessoais, entre em contato conosco.
          </p>
        </CardContent>
      </Card>
    </div>
  );
}
